/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractRememberMeServices
implements RememberMeServices,
InitializingBean,
LogoutHandler {
    public static final String SPRING_SECURITY_REMEMBER_ME_COOKIE_KEY = "SPRING_SECURITY_REMEMBER_ME_COOKIE";
    public static final String DEFAULT_PARAMETER = "_spring_security_remember_me";
    public static final int TWO_WEEKS_S = 1209600;
    private static final String DELIMITER = ":";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private UserDetailsService userDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private String cookieName = "SPRING_SECURITY_REMEMBER_ME_COOKIE";
    private String parameter = "_spring_security_remember_me";
    private boolean alwaysRemember;
    private String key;
    private int tokenValiditySeconds = 1209600;
    private Boolean useSecureCookie = null;
    private Method setHttpOnlyMethod;
    private GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();

    @Deprecated
    protected AbstractRememberMeServices() {
        this.setHttpOnlyMethod = ReflectionUtils.findMethod(Cookie.class, (String)"setHttpOnly", (Class[])new Class[]{Boolean.TYPE});
    }

    protected AbstractRememberMeServices(String key, UserDetailsService userDetailsService) {
        Assert.hasLength((String)key, (String)"key cannot be empty or null");
        Assert.notNull((Object)userDetailsService, (String)"UserDetailsService cannot be null");
        this.key = key;
        this.userDetailsService = userDetailsService;
        this.setHttpOnlyMethod = ReflectionUtils.findMethod(Cookie.class, (String)"setHttpOnly", (Class[])new Class[]{Boolean.TYPE});
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.key);
        Assert.notNull((Object)this.userDetailsService, (String)"A UserDetailsService is required");
    }

    @Override
    public final Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        String rememberMeCookie = this.extractRememberMeCookie(request);
        if (rememberMeCookie == null) {
            return null;
        }
        this.logger.debug((Object)"Remember-me cookie detected");
        if (rememberMeCookie.length() == 0) {
            this.logger.debug((Object)"Cookie was empty");
            this.cancelCookie(request, response);
            return null;
        }
        UserDetails user = null;
        try {
            String[] cookieTokens = this.decodeCookie(rememberMeCookie);
            user = this.processAutoLoginCookie(cookieTokens, request, response);
            this.userDetailsChecker.check(user);
            this.logger.debug((Object)"Remember-me cookie accepted");
            return this.createSuccessfulAuthentication(request, user);
        }
        catch (CookieTheftException cte) {
            this.cancelCookie(request, response);
            throw cte;
        }
        catch (UsernameNotFoundException noUser) {
            this.logger.debug((Object)"Remember-me login was valid but corresponding user not found.", (Throwable)noUser);
        }
        catch (InvalidCookieException invalidCookie) {
            this.logger.debug((Object)("Invalid remember-me cookie: " + invalidCookie.getMessage()));
        }
        catch (AccountStatusException statusInvalid) {
            this.logger.debug((Object)("Invalid UserDetails: " + statusInvalid.getMessage()));
        }
        catch (RememberMeAuthenticationException e) {
            this.logger.debug((Object)e.getMessage());
        }
        this.cancelCookie(request, response);
        return null;
    }

    protected String extractRememberMeCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    protected Authentication createSuccessfulAuthentication(HttpServletRequest request, UserDetails user) {
        RememberMeAuthenticationToken auth = new RememberMeAuthenticationToken(this.key, (Object)user, this.authoritiesMapper.mapAuthorities(user.getAuthorities()));
        auth.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return auth;
    }

    protected String[] decodeCookie(String cookieValue) throws InvalidCookieException {
        for (int j = 0; j < cookieValue.length() % 4; ++j) {
            cookieValue = cookieValue + "=";
        }
        if (!Base64.isBase64((byte[])cookieValue.getBytes())) {
            throw new InvalidCookieException("Cookie token was not Base64 encoded; value was '" + cookieValue + "'");
        }
        String cookieAsPlainText = new String(Base64.decode((byte[])cookieValue.getBytes()));
        String[] tokens = StringUtils.delimitedListToStringArray((String)cookieAsPlainText, (String)DELIMITER);
        if ((tokens[0].equalsIgnoreCase("http") || tokens[0].equalsIgnoreCase("https")) && tokens[1].startsWith("//")) {
            String[] newTokens = new String[tokens.length - 1];
            newTokens[0] = tokens[0] + DELIMITER + tokens[1];
            System.arraycopy(tokens, 2, newTokens, 1, newTokens.length - 1);
            tokens = newTokens;
        }
        return tokens;
    }

    protected String encodeCookie(String[] cookieTokens) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cookieTokens.length; ++i) {
            sb.append(cookieTokens[i]);
            if (i >= cookieTokens.length - 1) continue;
            sb.append(DELIMITER);
        }
        String value = sb.toString();
        sb = new StringBuilder(new String(Base64.encode((byte[])value.getBytes())));
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public final void loginFail(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug((Object)"Interactive login attempt was unsuccessful.");
        this.cancelCookie(request, response);
        this.onLoginFail(request, response);
    }

    protected void onLoginFail(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public final void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        if (!this.rememberMeRequested(request, this.parameter)) {
            this.logger.debug((Object)"Remember-me login not requested.");
            return;
        }
        this.onLoginSuccess(request, response, successfulAuthentication);
    }

    protected abstract void onLoginSuccess(HttpServletRequest var1, HttpServletResponse var2, Authentication var3);

    protected boolean rememberMeRequested(HttpServletRequest request, String parameter) {
        if (this.alwaysRemember) {
            return true;
        }
        String paramValue = request.getParameter(parameter);
        if (paramValue != null && (paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("on") || paramValue.equalsIgnoreCase("yes") || paramValue.equals("1"))) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Did not send remember-me cookie (principal did not set parameter '" + parameter + "')"));
        }
        return false;
    }

    protected abstract UserDetails processAutoLoginCookie(String[] var1, HttpServletRequest var2, HttpServletResponse var3) throws RememberMeAuthenticationException, UsernameNotFoundException;

    protected void cancelCookie(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug((Object)"Cancelling cookie");
        Cookie cookie = new Cookie(this.cookieName, null);
        cookie.setMaxAge(0);
        cookie.setPath(this.getCookiePath(request));
        response.addCookie(cookie);
    }

    protected void setCookie(String[] tokens, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        String cookieValue = this.encodeCookie(tokens);
        Cookie cookie = new Cookie(this.cookieName, cookieValue);
        cookie.setMaxAge(maxAge);
        cookie.setPath(this.getCookiePath(request));
        if (this.useSecureCookie == null) {
            cookie.setSecure(request.isSecure());
        } else {
            cookie.setSecure(this.useSecureCookie.booleanValue());
        }
        if (this.setHttpOnlyMethod != null) {
            ReflectionUtils.invokeMethod((Method)this.setHttpOnlyMethod, (Object)cookie, (Object[])new Object[]{Boolean.TRUE});
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Note: Cookie will not be marked as HttpOnly because you are not using Servlet 3.0 (Cookie#setHttpOnly(boolean) was not found).");
        }
        response.addCookie(cookie);
    }

    private String getCookiePath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return contextPath.length() > 0 ? contextPath : "/";
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Logout of user " + (authentication == null ? "Unknown" : authentication.getName())));
        }
        this.cancelCookie(request, response);
    }

    public void setCookieName(String cookieName) {
        Assert.hasLength((String)cookieName, (String)"Cookie name cannot be empty or null");
        this.cookieName = cookieName;
    }

    protected String getCookieName() {
        return this.cookieName;
    }

    public void setAlwaysRemember(boolean alwaysRemember) {
        this.alwaysRemember = alwaysRemember;
    }

    public void setParameter(String parameter) {
        Assert.hasText((String)parameter, (String)"Parameter name cannot be empty or null");
        this.parameter = parameter;
    }

    public String getParameter() {
        return this.parameter;
    }

    protected UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    @Deprecated
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        Assert.notNull((Object)userDetailsService, (String)"UserDetailsService canot be null");
        this.userDetailsService = userDetailsService;
    }

    @Deprecated
    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        this.tokenValiditySeconds = tokenValiditySeconds;
    }

    protected int getTokenValiditySeconds() {
        return this.tokenValiditySeconds;
    }

    public void setUseSecureCookie(boolean useSecureCookie) {
        this.useSecureCookie = useSecureCookie;
    }

    protected AuthenticationDetailsSource<HttpServletRequest, ?> getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"AuthenticationDetailsSource cannot be null");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setUserDetailsChecker(UserDetailsChecker userDetailsChecker) {
        this.userDetailsChecker = userDetailsChecker;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }
}

