/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

import java.io.IOException;
import net.wimpi.modbus.io.BytesOutputStream;
import net.wimpi.modbus.msg.ModbusMessage;

public final class ModbusUtil {
    private static BytesOutputStream m_ByteOut = new BytesOutputStream(260);
    private static final short[] auchCRCHi = new short[]{0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64};
    private static final short[] auchCRCLo = new short[]{0, 192, 193, 1, 195, 3, 2, 194, 198, 6, 7, 199, 5, 197, 196, 4, 204, 12, 13, 205, 15, 207, 206, 14, 10, 202, 203, 11, 201, 9, 8, 200, 216, 24, 25, 217, 27, 219, 218, 26, 30, 222, 223, 31, 221, 29, 28, 220, 20, 212, 213, 21, 215, 23, 22, 214, 210, 18, 19, 211, 17, 209, 208, 16, 240, 48, 49, 241, 51, 243, 242, 50, 54, 246, 247, 55, 245, 53, 52, 244, 60, 252, 253, 61, 255, 63, 62, 254, 250, 58, 59, 251, 57, 249, 248, 56, 40, 232, 233, 41, 235, 43, 42, 234, 238, 46, 47, 239, 45, 237, 236, 44, 228, 36, 37, 229, 39, 231, 230, 38, 34, 226, 227, 35, 225, 33, 32, 224, 160, 96, 97, 161, 99, 163, 162, 98, 102, 166, 167, 103, 165, 101, 100, 164, 108, 172, 173, 109, 175, 111, 110, 174, 170, 106, 107, 171, 105, 169, 168, 104, 120, 184, 185, 121, 187, 123, 122, 186, 190, 126, 127, 191, 125, 189, 188, 124, 180, 116, 117, 181, 119, 183, 182, 118, 114, 178, 179, 115, 177, 113, 112, 176, 80, 144, 145, 81, 147, 83, 82, 146, 150, 86, 87, 151, 85, 149, 148, 84, 156, 92, 93, 157, 95, 159, 158, 94, 90, 154, 155, 91, 153, 89, 88, 152, 136, 72, 73, 137, 75, 139, 138, 74, 78, 142, 143, 79, 141, 77, 76, 140, 68, 132, 133, 69, 135, 71, 70, 134, 130, 66, 67, 131, 65, 129, 128, 64};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toHex(ModbusMessage msg) {
        String ret = "-1";
        try {
            BytesOutputStream bytesOutputStream = m_ByteOut;
            synchronized (bytesOutputStream) {
                msg.writeTo(m_ByteOut);
                ret = ModbusUtil.toHex(m_ByteOut.getBuffer(), 0, m_ByteOut.size());
                m_ByteOut.reset();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static final String toHex(byte[] data) {
        return ModbusUtil.toHex(data, 0, data.length);
    }

    public static final String toHex(byte[] data, int off, int length) {
        StringBuffer buf = new StringBuffer(data.length * 2);
        for (int i = off; i < length; ++i) {
            if ((data[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(data[i] & 0xFF, 16));
            if (i >= data.length - 1) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static final byte[] toHex(int i) {
        StringBuffer buf = new StringBuffer(2);
        if ((i & 0xFF) < 16) {
            buf.append("0");
        }
        buf.append(Long.toString(i & 0xFF, 16).toUpperCase());
        return buf.toString().getBytes();
    }

    public static final int registerToUnsignedShort(byte[] bytes) {
        return (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
    }

    public static final byte[] unsignedShortToRegister(int v) {
        byte[] register = new byte[]{(byte)(0xFF & v >> 8), (byte)(0xFF & v)};
        return register;
    }

    public static final short registerToShort(byte[] bytes) {
        return (short)(bytes[0] << 8 | bytes[1] & 0xFF);
    }

    public static final short registerToShort(byte[] bytes, int idx) {
        return (short)(bytes[idx] << 8 | bytes[idx + 1] & 0xFF);
    }

    public static final byte[] shortToRegister(short s) {
        byte[] register = new byte[]{(byte)(0xFF & s >> 8), (byte)(0xFF & s)};
        return register;
    }

    public static final int registersToInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static final byte[] intToRegisters(int v) {
        byte[] registers = new byte[]{(byte)(0xFF & v >> 24), (byte)(0xFF & v >> 16), (byte)(0xFF & v >> 8), (byte)(0xFF & v)};
        return registers;
    }

    public static final long registersToLong(byte[] bytes) {
        return (long)(bytes[0] & 0xFF) << 56 | (long)(bytes[1] & 0xFF) << 48 | (long)(bytes[2] & 0xFF) << 40 | (long)(bytes[3] & 0xFF) << 32 | (long)(bytes[4] & 0xFF) << 24 | (long)(bytes[5] & 0xFF) << 16 | (long)(bytes[6] & 0xFF) << 8 | (long)(bytes[7] & 0xFF);
    }

    public static final byte[] longToRegisters(long v) {
        byte[] registers = new byte[]{(byte)(0xFFL & v >> 56), (byte)(0xFFL & v >> 48), (byte)(0xFFL & v >> 40), (byte)(0xFFL & v >> 32), (byte)(0xFFL & v >> 24), (byte)(0xFFL & v >> 16), (byte)(0xFFL & v >> 8), (byte)(0xFFL & v)};
        return registers;
    }

    public static final float registersToFloat(byte[] bytes) {
        return Float.intBitsToFloat((bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF);
    }

    public static final byte[] floatToRegisters(float f) {
        return ModbusUtil.intToRegisters(Float.floatToIntBits(f));
    }

    public static final double registersToDouble(byte[] bytes) {
        return Double.longBitsToDouble((long)(bytes[0] & 0xFF) << 56 | (long)(bytes[1] & 0xFF) << 48 | (long)(bytes[2] & 0xFF) << 40 | (long)(bytes[3] & 0xFF) << 32 | (long)(bytes[4] & 0xFF) << 24 | (long)(bytes[5] & 0xFF) << 16 | (long)(bytes[6] & 0xFF) << 8 | (long)(bytes[7] & 0xFF));
    }

    public static final byte[] doubleToRegisters(double d) {
        return ModbusUtil.longToRegisters(Double.doubleToLongBits(d));
    }

    public static final int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static final byte lowByte(int wd) {
        return new Integer(0xFF & wd).byteValue();
    }

    public static final byte hiByte(int wd) {
        return new Integer(0xFF & wd >> 8).byteValue();
    }

    public static final int makeWord(int hibyte, int lowbyte) {
        int hi = 0xFF & hibyte;
        int low = 0xFF & lowbyte;
        return hi << 8 | low;
    }

    public static final int[] calculateCRC(byte[] data, int offset, int len) {
        int[] crc = new int[]{255, 255};
        int nextByte = 0;
        for (int i = offset; i < len && i < data.length; ++i) {
            nextByte = 0xFF & data[i];
            int uIndex = crc[0] ^ nextByte;
            crc[0] = crc[1] ^ auchCRCHi[uIndex];
            crc[1] = auchCRCLo[uIndex];
        }
        return crc;
    }

    public static final int calculateLRC(byte[] data, int off, int len) {
        int lrc = 0;
        for (int i = off; i < len; ++i) {
            lrc += data[i] & 0xFF;
        }
        lrc = (lrc ^ 0xFF) + 1;
        return (byte)lrc & 0xFF;
    }
}

